#include "g_local.h"

void MatchSetupScoreboardMessage (edict_t *ent, edict_t *killer)
{
	char	entry[1024];
	char	string[1400];
	char	temp[64];
	int		stringlength;
	int		i, j, k;
	int		sorted[MAX_CLIENTS];
	int		sortedscores[MAX_CLIENTS];
	int		score, total, real_total;
//	int		picnum;
	int		x, y;
	int		found;
	gclient_t	*cl;
	edict_t		*cl_ent, *player;
	char	*tag;
	int		team;
	char	*header = "NAME         ping hits depst";// score";
	char	nfill[64];
	int		yofs=10;
	int		teamcount[3];
	char	*selectheader[] =
		{
			"Valid teams are:",
			NULL
		};


//			"%12s - 1 (%i players)"\n%12s - 2\n\n--------------------------------------------------------\n", team_names[1], team_names[2]


	x = (-1*strlen(header) - 2) * 10;	// 10 pixels per char

	string[0] = 0;
	stringlength = 0;

    if ((deathmatch->value || coop->value) && (ent->is_bot))
    return;
	
	if ((int)teamplay->value == 0)
		Com_sprintf (temp, sizeof(temp), "This server is running Standard Deathmatch");
	else if ((int)teamplay->value == 1)
		Com_sprintf (temp, sizeof(temp), "This server is running Bagman");
	else if ((int)teamplay->value == 4)
		Com_sprintf (temp, sizeof(temp), "This server is running Team Deathmatch");

	Com_sprintf (entry, sizeof(entry), "xm %i yv %i dmstr 874 \"%s\" ",
		-5*strlen(temp), yofs + (int)(-60.0+-3.5*14), temp );
	yofs += 20;
	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;
		

	if (level.modeset == MATCHSETUP)
		Com_sprintf (temp, sizeof(temp), "in Match Setup Mode.");
	else if (level.modeset == FINALCOUNT)
		Com_sprintf (temp, sizeof(temp), "and is in the Final Countdown before a Match.");
	else if (level.modeset == FREEFORALL)
		if (teamplay->value)
			Com_sprintf (temp, sizeof(temp), "The Game will start soon. Please even the Teams!");
		else
			Com_sprintf (temp, sizeof(temp), "The Game will start soon.");

	Com_sprintf (entry, sizeof(entry), "xm %i yv %i dmstr 874 \"%s\" ",
		-5*strlen(temp), yofs + (int)(-60.0+-3.5*14), temp );
	yofs += 20;
	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;


	i=0;
	found = FALSE;
	while ((!found) && (i<maxclients->value)) 
	{
		player = g_edicts + 1 + i;
		i++;
		if (!player->inuse)
			continue;
		if (player->client->pers.admin > NOT_ADMIN)
			found = TRUE;
	}

	if (found)
		Com_sprintf (temp, sizeof(temp), "Your admin is %s",player->client->pers.netname);
	else
		Com_sprintf (temp, sizeof(temp), "No one currently has admin");

	Com_sprintf (entry, sizeof(entry), "xm %i yv %i dmstr 874 \"%s\" ",
		-5*strlen(temp), yofs + (int)(-60.0+-3.5*14), temp );
	yofs += 30;
	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;


	// count players per team
	memset( teamcount, 0, sizeof(int) * 3 );

	for (team=1; team<=2; team++)
	{
		for (i=0 ; i<game.maxclients ; i++)
		{
			cl_ent = g_edicts + 1 + i;
			if (!cl_ent->inuse)
				continue;

			if (game.clients[i].pers.team != team)
				continue;

			teamcount[team]++;
		}
	}

	// print the team selection header
	for (i=0; selectheader[i]; i++)
	{
		Com_sprintf (entry, sizeof(entry),
			"xm %i yv %i dmstr 999 \"%s\" ",
			-5*strlen(selectheader[i]), yofs + (int)(-60.0+-3.5*14), selectheader[i] );

		j = strlen(entry);
		strcpy (string + stringlength, entry);
		stringlength += j;

		yofs += 30;
	}

	// show team counts
	for (team=1; team<=2; team++)
	{
		strcpy( nfill, team_names[team] );
		if (strlen(nfill) > 14)
			nfill[14] = '\0';

		if (strlen(team_names[team]) < 14)
		{
			for (k=0; k<14-strlen(team_names[team]); k++)
				strcat( nfill, " " );
		}

		Com_sprintf (entry, sizeof(entry),
			"xm %i yv %i dmstr 999 \"%i - %s (%i plyrs)\" ",
			-15*10, yofs + (int)(-60.0+-3.5*14), team, nfill, teamcount[team] );

		j = strlen(entry);
		strcpy (string + stringlength, entry);
		stringlength += j;

		yofs += 20;
	}

	yofs += 15;

	if (!ent->client->chase_target)
	{
		char	*chasecammsg = "[hit ACTIVATE to chase]";

		// Chase Cam message
		Com_sprintf (entry, sizeof(entry),
			"xm %i yb -50 dmstr 773 \"%s\" ",
			-5*strlen(chasecammsg), chasecammsg );

		j = strlen(entry);
		strcpy (string + stringlength, entry);
		stringlength += j;

	}

	for (team=1; team<=2; team++)
	{

		// Team header
		Com_sprintf (entry, sizeof(entry),
			"xm %i yv %i tscore %i xm %i dmstr 677 \"%s\" teampic %i ",
			x+14*10, yofs + (int)(-60.0+-3.5*14), team, x, team_names[team], team );

		j = strlen(entry);
		strcpy (string + stringlength, entry);
		stringlength += j;

		// sort the clients by score
		total = 0;
		for (i=0 ; i<game.maxclients ; i++)
		{
			cl_ent = g_edicts + 1 + i;
			if (!cl_ent->inuse)
				continue;

			if (game.clients[i].pers.team != team)
				continue;

			// Tweaked to produce
//			score = (int)(1.0*game.clients[i].resp.score + (0.3*game.clients[i].resp.deposited));
			score = game.clients[i].resp.deposited + game.clients[i].resp.score;	// so it works in games without cash

			for (j=0 ; j<total ; j++)
			{
				if (score > sortedscores[j])
					break;
			}
			for (k=total ; k>j ; k--)
			{
				sorted[k] = sorted[k-1];
				sortedscores[k] = sortedscores[k-1];
			}
			sorted[j] = i;
			sortedscores[j] = score;
			total++;
		}

		real_total = total;

		// header
//#if ENABLE_INDEX_NAMES
		if (ent->client->pers.version >= 114)
		{

			// add the clients in sorted order
			if (ent->client->pers.team)
			{
				if (total > 10)
					total = 10;
			}
			else	// don't show as much, less space remaining
			{
				if (total > 7)
					total = 7;
			}

		}
//#else
		else
		{

			if (ent->client->pers.team)
			{
				if (total > 5)
					total = 5;
			}
			else	// don't show as much, less space remaining
			{
				if (total > 3)
					total = 3;
			}

		}
//#endif

		Com_sprintf (entry, sizeof(entry),
			"yv %i dmstr 663 \"%s\" ",
			yofs + (int)(-60.0+-1.5*14), header );

		j = strlen(entry);
		strcpy (string + stringlength, entry);
		stringlength += j;

		for (i=0 ; i<total ; i++)
		{
			cl = &game.clients[sorted[i]];
			cl_ent = g_edicts + 1 + sorted[i];

	//		picnum = gi.imageindex ("i_fixme");
			y = 32 + 32 * i;

			if (i < 2)
				y -= 16;

			if (cl_ent == ent)
				tag = "990";
			else if (cl_ent == killer)
				tag = "960";
			else
				tag = "999";	// fullbright

//#if ENABLE_INDEX_NAMES
			if (ent->client->pers.version >= 114)
			{
				Com_sprintf (entry, sizeof(entry),
					"yv %i ds %s %i %i %i %i ",// %5i\" ",					// ~28 chars
					yofs + -60+i*16, tag, sorted[i]/*nfill*/, cl->ping, cl->resp.score, cl->resp.deposited/*, sortedscores[i]*/ );

			}
//#else
			else
			{

				strcpy( nfill, cl->pers.netname );
				if (strlen(nfill) > 12)
					nfill[12] = '\0';

				if (strlen(cl->pers.netname) < 12)
				{
					for (k=0; k<12-strlen(cl->pers.netname); k++)
						strcat( nfill, " " );
				}

				Com_sprintf (entry, sizeof(entry),
					"yv %i dmstr %s \"%s %4i %4i %5i \" ",// %5i\" ",		// 48 chars
					yofs + -60+i*16, tag, nfill, cl->ping, cl->resp.score, cl->resp.deposited/*, sortedscores[i]*/ );

			}
//#endif

			j = strlen(entry);
			if (stringlength + j > 1024)
				break;
			strcpy (string + stringlength, entry);
			stringlength += j;
		}

		if (real_total > total)
		{	// show the nuber of undisplayed players

			Com_sprintf (entry, sizeof(entry),
				"yv %i dmstr 777 \"(%i players)\" ",
				yofs + -60+i*16 + 6, real_total );

			j = strlen(entry);
			if (stringlength + j > 1024)
				break;
			strcpy (string + stringlength, entry);
			stringlength += j;
		}

		x = -8;
	}

	
	// TODO: add the spectators at the bottom

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}

